define([
    'backbone',
    'Layout',
    'modules/community-care-request/new-appointment-request-question/preferred-provider/choices/choice-layout-view', // eslint-disable-line max-len
], function(
    Backbone,
    Layout,
    ChoiceLayoutView
) {
    'use strict';
    describe('Choice Layout', function() {
        var view;
        var model;
        var layout;
        var provider1;
        var provider2;
        var provider3;

        beforeEach(function() {
            layout = new Layout();
            layout.render();
            spyOn(ChoiceLayoutView.prototype, 'hideDeleteBtn');
            model = new Backbone.Model({steps: [5]});

            view = new ChoiceLayoutView({
                model: model,
            });
            layout.showChildView('content', view);
        });


        afterEach(function () {
            layout.getRegion('content').empty();
        });

        describe('when it shows the layout', function() {
            it('displays a provider on show', function() {
                model = new Backbone.Model({steps: [5]});
                view = new ChoiceLayoutView({
                    model: model,
                });
                view.render();
                expect(view.model.get('preferredProviders').length > 0).toBeTruthy();
                view.model.get('preferredProviders').each(function(value) {
                    expect(value.get('id')).toEqual(1);
                });
            });
        });
        describe('the layout adding a new provider depending on length', function() {
            it('adds a new provider if the provider length is less than 3', function() {
                provider1 = new Backbone.Model({ 'id': 1 });
                model = new Backbone.Model({steps: [5]});
                model.set('preferredProviders', new Backbone.Collection(provider1));
                view = new ChoiceLayoutView({
                    model: model,
                });
                view.render();
                view.showAdditionalProvider();
                expect(view.model.get('preferredProviders').length).toEqual(2);
                view.model.get('preferredProviders').each(function(value, index) {
                    expect(value.get('id')).toEqual(index + 1);
                });
            });
            it('adds a new provider to max length', function() {
                provider1 = new Backbone.Model({ 'id': 1 });
                provider2 = new Backbone.Model({ 'id': 2 });
                model = new Backbone.Model({steps: [5]});
                model.set('preferredProviders', new Backbone.Collection(provider1));
                model.get('preferredProviders').add(provider2);
                view = new ChoiceLayoutView({
                    model: model,
                });
                view.render();
                view.showAdditionalProvider();
                expect(view.model.get('preferredProviders').length).toEqual(3);
                view.model.get('preferredProviders').each(function(value, index) {
                    expect(value.get('id')).toEqual(index + 1);
                });
            });
        });

        describe('provider list removing providers', function() {
            it('removes 1 provider', function() {
                provider1 = new Backbone.Model({ 'id': 1 });
                provider2 = new Backbone.Model({ 'id': 2 });
                provider3 = new Backbone.Model({ 'id': 3 });
                model = new Backbone.Model({steps: [5]});
                model.set('preferredProviders', new Backbone.Collection(provider1));
                model.get('preferredProviders').add(provider2);
                model.get('preferredProviders').add(provider3);
                view = new ChoiceLayoutView({
                    model: model,
                });
                view.render();
                view.deleteProvider(3);
                expect(view.model.get('preferredProviders').length).toEqual(2);
                view.model.get('preferredProviders').each(function(value, index) {
                    expect(value.get('id')).toEqual(index + 1);
                });
            });
            it('removes 2 providers', function() {
                provider1 = new Backbone.Model({ 'id': 1 });
                provider2 = new Backbone.Model({ 'id': 2 });
                provider3 = new Backbone.Model({ 'id': 3 });
                model = new Backbone.Model({steps: [5]});
                model.set('preferredProviders', new Backbone.Collection(provider1));
                model.get('preferredProviders').add(provider2);
                model.get('preferredProviders').add(provider3);
                view = new ChoiceLayoutView({
                    model: model,
                });
                view.render();
                view.deleteProvider(3);
                view.deleteProvider(2);
                expect(view.model.get('preferredProviders').length).toEqual(1);
                view.model.get('preferredProviders').each(function(value, index) {
                    expect(value.get('id')).toEqual(1);
                });
            });
        });

    });
});
